﻿function deepObjectCopy(obj:Object):Object 
{
	if (typeof obj != "object"
	||  object instanceof Button
	||  object instanceof TextField
	||  object instanceof MovieClip)
	{
		// display object (return reference)
		// or non-object value (return value)
		return obj;
	}
	var copy;
	// define copy object type
	// Boolean, Number, and String objects can be defined
	// as objects with a base value (and can be given properties)
	// class valueOf used to retrieve base value
	if (obj instanceof Boolean)
	{
		copy = new Boolean(Boolean.prototype.valueOf.call(obj));
	} else if (obj instanceof Number)
	{
		copy = new Number(Number.prototype.valueOf.call(obj));
	} else if (obj instanceof String)
	{
		copy = new String(String.prototype.valueOf.call(obj));
		// for other objects use object's __constructor__
		// to create copy if exists
		// assumes no required parameters
	} else if (obj.__constructor__)
	{
		copy = new obj.__constructor__();
		// __constructor__ will not be available for
		// Array and Object instances defined in shorthand
	} else if (obj instanceof Array)
	{
		copy = [];
	} else {
		copy = {};
	}
	// copy object properties
	for (var p in obj)
	{
		// only copy properties unique to object
		// assumes all properties enumerable
		if (obj.hasOwnProperty(p))
		{
			// deep copy the property being assigned
			copy[p] = arguments.callee(obj[p]);
		}
	}
	// return copy
	return copy;
}